*********** Disagreement and Uncertainty: Section 4 of paper
*** Table 4: Realizations and Expectation so Forecast Accuracy
use "AllDerivatives", clear
table statistic, c(n ameanerr m astd sd ameanerr sd mmeanerr)

* Figure 4: Disagreement and Uncertainty
use "AllDerivatives", clear

sort statno time
egen enddate=max(dtrelease), by(statno)
fillin statno time
drop if time>enddate
for var astd mstd: ipolate X time, by(statno) g(iX)
for var iastd imstd: gen avX=(l2.X+l.X+X+f.X+f2.X)/5
for var aviastd avimstd: replace X=. if _fillin==1
#delimit;
twoway 
	(line astd dtrelease, sort clcolor(navy)) 
	(line mstd dtrelease, sort clcolor(cranberry)) 
	(line aviastd dtrelease, sort clcolor(midblue) clpat(dash) connect(direct)) 
	(line avimstd dtrelease, sort clcolor(red) clpat(dash))
,
	by(stat, note("Dashed lines show 5-period centered moving averages")
	yrescale title(Disagreement and Uncertainty)) 
	ylabel(, angle(horizontal)) 
	ytitle("Standard Deviation")  
	xtitle("Date of Data Release") 
	xlabel(, format(%dn/Y)) 
	caption(, size(zero)) 
	legend(rows(2) order(1 "Uncertainty: Standard Deviation of Market-Based PDF" 2 "Disagreement: Standard Deviation of Estimates Among MMS Forecasters")) 
	xsize(10) ysize(7.5);
#delimit cr
pause

* Table 5: Disagreement and Uncertainty
bys statistic: reg astd mstd 
xi: reg astd i.statistic*mstd
testparm mstd _IstaX*
bys statistic: reg aviastd avimstd
xi: reg aviastd i.statistic*avimstd
testparm avimstd _IstaX*

* Table 6: Modelling Uncertainty
use "AllDerivatives(scaled)", clear
* Merge in "VIX.dta"
gen dt=dtauction-1
gen vix1=.
forvalues i=1(1)5 {
	sort dt
	merge dt using "VIX.dta", nokeep
	replace vix1=vixclose if vix1==.
	replace dt=dt-1 
	drop date vixopen vixhigh vixlow vixclose lagvixclose _merge
}

replace dt=dtauction-1-30
replace dt=dtauction-1-7 if statistic=="iclm"
gen vix2=.
forvalues i=1(1)5 {
	sort dt
	merge dt using "VIX.dta", nokeep
	replace vix2=vixclose if vix2==.
	replace dt=dt-1
	drop date vixopen vixhigh vixlow vixclose lagvixclose _merge
}

replace dt=dtauction-1-30-30
replace dt=dtauction-1-7-7 if statistic=="iclm"
gen vix3=.
forvalues i=1(1)5 {
	sort dt
	merge dt using "VIX.dta", nokeep
	replace vix3=vixclose if vix3==.
	replace dt=dt-1
	drop date vixopen vixhigh vixlow vixclose lagvixclose _merge
}

for var vix1-vix3: replace X=X/100

* Panel A
for X in any iclm napm nfpay rsxaut : reg astd vix1 vix2 vix3 if statistic=="X" \ testparm vix*
pause

* Panel B: Note that the lags are lags of Auctions, not data releases
sort statistic dtrelease
for num 1/3: bys statistic: gen astdX=astd[_n-X]
for X in any iclm napm nfpay rsxaut : reg astd astd1 astd2 astd3 if statistic=="X" \ test astd1 astd2 astd3
pause

* Panel B (not shown): Analyze lags of data releases 
sort statno time
for num 1/3: gen astdlX=lX.astd
for X in any iclm napm nfpay rsxaut : reg astd astdl1 astdl2 astdl3 if statistic=="X" \ test astdl1 astdl2 astdl3

* Panel C
sort statistic dtrelease
for num 1/3: bys statistic: gen ameanerrX=((ameanerr[_n-X]))^2
for X in any iclm napm nfpay rsxaut : reg astd astd1 astd2 astd3 ameanerr1 ameanerr2 ameanerr3 if statistic=="X" \ testparm astd* \ testparm ameanerr*
pause


* Figure 5: Uncertainty and Forecast Errors
gen absameanerr=abs(ameanerr)
#delimit;
twoway 
	(lfit absameanerr astd, sort) 
	(scatter absameanerr astd)
,
	by(stat, xrescale yrescale title(Uncertainty and Forecast Errors) legend(off) note("Data scaled by historical standard error of survey-based forecasts")) 
	ytitle(Absolute Forecast Error)
	ylabel(,angle(horizontal))
	xtitle("Uncertainty (SD of the Market-based State Price Distribution)")
	xsize(10) ysize(7.5);
#delimit cr
pause

* Table 7: Uncertainty and Forecast Errors
for X in any iclm napm nfpay rsxaut: reg absameanerr astd if statistic=="X"\ test astd
xi: reg absameanerr i.statistic*astd
testparm astd _IstaXastd*
gen testone=absameanerr-astd
for X in any iclm napm nfpay rsxaut: reg testone astd if statistic=="X" \ test astd
xi: reg testone i.statistic*astd
testparm astd _IstaXastd*
pause

